<?php


namespace App\Payment\Tamara;

use App\Models\Order;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Http;

class Tamara
{
    public $sandbox_url="https://api-sandbox.tamara.co";
    public $production_url="https://api.tamara.co";

    public $sandbox_token="Bearer eyJ0eXAiOiJKV1QiLCJhbGciOiJSUzI1NiJ9.eyJhY2NvdW50SWQiOiI1NDUxOTRmYy05MWY5LTQ3ZjMtOGNiYy1kYjIwNTMwOGQyMTciLCJ0eXBlIjoibWVyY2hhbnQiLCJzYWx0IjoiYzk4NmY3NGFkZTRmNmQ4YjhlOGJjNWZiYWNiMjMxOWEiLCJpYXQiOjE2ODE4MTQwNjgsImlzcyI6IlRhbWFyYSJ9.V7_IFJfr-snRuhnAYfHTTcPY0Akd0BEM2JlXZcObl-fU5LqyLTxp-UgIW3JNfOKM1Fh2H0p8d24FOGB88VXvVGWV8YsttAepNSYFisArLWNz6lUaK1BTm0TQAmh9cLEO0mKypJiKYNtX_aQkdkvO4zesX3A2Go6H-YskBbQAWnDzy1bD0lgEpOUqgkNXUDqfI4ixwIGU1vyuycAcJMSoVonbCRIuUC9l-mZeFUiEeQ3op-Czz0a7JMJVDdktYIMjFctYTTZaTEbSaeEu_PELKt8c0nZSul6BADgc5ZaaA5H4E5OLyo05oR8r31JKy2kdOD_cvLXMwq8PmPn80UT_ZA";

   public function get_payment_types($currency='SA'){

       $payload=['country'=>$currency];

       $response = Http::withHeaders([

           'Authorization' => $this->sandbox_token,

       ])->get("$this->sandbox_url/checkout/payment-types",$payload);


       if ($response->successful()) {

           return $response = $response->json();

       } else {
           return $statusCode = $response->status();


       }
   }


   public function get_payment_link($amount_payment,$currency,$success_url,$failure_url,$id_order){



       $payload = '{
            "order_reference_id": "100",
            "order_number": "A123456",
            "total_amount": {
                "amount": 100,
                "currency": "SAR"
                },
                "description": "string",
                "country_code": "SA",
                "payment_type": "PAY_BY_INSTALMENTS",
                "instalments": null,
                "locale": "en_US",
                "items": [
                {
                "reference_id": "500",
                "type": "Digital",
                "name": "Lego City 8601",
                "sku": "SA-12436",
                "image_url": "https://www.example.com/product.jpg",
                "item_url": "https://www.example.com/product.html",
                "quantity": 1,
                "unit_price": {
                "amount": "100.00",
                "currency": "SAR"
                },
            "discount_amount": {
            "amount": "0.00",
            "currency": "SAR"
            },
            "tax_amount": {
            "amount": "100.00",
            "currency": "SAR"
            },
            "total_amount": {
            "amount": "100.00",
            "currency": "SAR"
            }
            }
            ],
            "consumer": {
            "first_name": "Mona",
            "last_name": "Lisa",
            "phone_number": "502223333",
            "email": "user@example.com"
            },
            "billing_address": {
                "first_name": "Mona",
                        "last_name": "Lisa",
                        "line1": "3764 Al Urubah Rd",
                        "line2": "string",
                        "region": "As Sulimaniyah",
                        "postal_code": "12345",
                        "city": "Riyadh",
                        "country_code": "SA",
                        "phone_number": "502223333"
                        },
                        "shipping_address": {
                        "first_name": "Mona",
                        "last_name": "Lisa",
                        "line1": "3764 Al Urubah Rd",
                        "line2": "string",
                        "region": "As Sulimaniyah",
                        "postal_code": "12345",
                        "city": "Riyadh",
                        "country_code": "SA",
                        "phone_number": "502223333"
                        },
                        "discount": {
                        "name": "Christmas 2020",
                        "amount": {
                        "amount": "0.00",
                        "currency": "SAR"
                        }
                        },
                        "tax_amount": {
                        "amount": "0.00",
                        "currency": "SAR"
                        },
                        "shipping_amount": {
                        "amount": "0.00",
                        "currency": "SAR"
                        },
                        "merchant_url": {
                        "success": "https://example.com/checkout/success",
                        "failure": "https://example.com/checkout/failure",
                        "cancel": "https://example.com/checkout/cancel",
                        "notification": "https://webhook.site/00e65af2-e2c5-4ba8-9b50-72185f09cf90"
                        },
                "platform": "Magento",
                "is_mobile": false,
                "risk_assessment": {
                "customer_age": 22,
                "customer_dob": "31-01-2000",
                "customer_gender": "Male",
                "customer_nationality": "SA",
                "is_premium_customer": true,
                "is_existing_customer": true,
                "is_guest_user": true,
                "account_creation_date": "31-01-2019",
                "platform_account_creation_date": "string",
                "date_of_first_transaction": "31-01-2019",
                "is_card_on_file": true,
                "is_COD_customer": true,
                "has_delivered_order": true,
                "is_phone_verified": true,
                "is_fraudulent_customer": true,
                "total_ltv": 501.5,
                "total_order_count": 12,
                "order_amount_last3months": 301.5,
                "order_count_last3months": 2,
                "last_order_date": "31-01-2021",
                "last_order_amount": 301.5,
                "reward_program_enrolled": true,
                "reward_program_points": 300
                 },
                "expires_in_minutes": 0,
                "additional_data": {
                 "delivery_method": "home delivery",
                 "pickup_store": "Store A",
                 "store_code": "Store code A",
                "vendor_info": [
                {
                "vendor_amount": 0,
                "merchant_settlement_amount": 0,
                "vendor_reference_code": "string"
                }
                ]
                }
                }';

       $payload = json_decode($payload, true);
       $order = Order::with('addresses.cities.countries')->find($id_order);
       $user = Auth::user();


        $payload['merchant_url']['success']=$success_url;

       $payload['merchant_url']['failure']=$failure_url;
       $payload['merchant_url']['cancel']=$failure_url;


       $payload['total_amount']['amount']=$amount_payment;
       $payload['total_amount']['currency']=$currency;
      
       $payload['consumer']['first_name']=$user->user_name;
       $payload['consumer']['email']=$user->email;
       $payload['consumer']['phone_number']=$order->addresses->cmobile;
       $payload['billing_address']['first_name']=$user->user_name;
       $payload['billing_address']['region']=$order->addresses->cities->name_ar;
       $payload['billing_address']['city']=$order->addresses->cities->name_ar;
       $payload['billing_address']['phone_number']=$order->addresses->cmobile;
       $payload['billing_address']['line1']=$order->addresses->cpobox.' '.$order->addresses->czip.' '.$order->addresses->cities->name_ar.' '.$order->addresses->cities->countries->name_ar;

        
      



       $response = Http::withHeaders([

           'Authorization' => $this->sandbox_token,

       ])->post("$this->sandbox_url/checkout",$payload);


    //   dd($response->body());

       if ($response->body()) {

                $response = $response->json();

            if (!isset($response['checkout_url']) && ! isset($response['order_id'])){
                toastr()->error("خطا اثناء الاتصال بتمارا");
                return ['payment_link'=>route('home'),'order_id'=>'deny'];
            }


            else{
            return ['payment_link'=>$response['checkout_url'],'order_id'=>$response['order_id']];}

       } else {
           return $statusCode = $response->status();


       }

}

    public function Auth_order($uuid_order){
        $response = Http::withHeaders([

            'Authorization' => $this->sandbox_token,

        ])->post("$this->sandbox_url/orders/$uuid_order/authorise");


        dd($response->body());
        if ($response->body()) {

             $response = $response->json();


            if(isset($response['authorized_amount'])){
               return $response['authorized_amount'];
            }else{return "ERROR IN ID !!";}



        } else {
            return $statusCode = $response->status();


        }
    }

    public function capture($uuid_order){
       $auth=$this->Auth_order($uuid_order);

       $payload='{
            "order_id": "4e063619-8dd7-49d9-98f0-92ff3a7be57a",
            "total_amount": {
              "amount": "100.00",
              "currency": "SAR"
            },
           
            "shipping_info": {
              "shipped_at": "2019-08-24T14:15:22Z",
              "shipping_company": "DHL",
              "tracking_number": "123456",
              "tracking_url": "https://shipping.com/tracking?id=123456"
            }
          }';
        $payload = json_decode($payload, true);


        $payload['order_id']=$uuid_order;
        $payload['total_amount']=$auth;

        $response = Http::withHeaders([

            'Authorization' => $this->sandbox_token,

        ])->post("$this->sandbox_url/payments/capture",$payload);




         dd($response->body());
        if ($response->body()) {






            if($response->successful()){
                return 'done';
            }
            elseif(!isset($response['event_type'])){return "طلب مرفوض";}
            else{return "error";}



        } else {
            return $statusCode = $response->status();


        }
    }



}